<?php
/**
 * Quote Tag
 *
 * @package     AutomatorWP\Integrations\Jetpack_CRM\Actions\Quote_Tag
 * @author      AutomatorWP <contact@automatorwp.com>, Ruben Garcia <rubengcdev@gmail.com>
 * @since       1.0.0
 */
// Exit if accessed directly

if( !defined( 'ABSPATH' ) ) exit;

class AutomatorWP_Jetpack_CRM_Quote_Tag extends AutomatorWP_Integration_Action {

    public $integration = 'jetpack_crm';
    public $action = 'jetpack_crm_quote_tag';

    /**
     * Register the trigger
     *
     * @since 1.0.0
     */
    public function register() {

        automatorwp_register_action( $this->action, array(
            'integration'       => $this->integration,
            'label'             => __( 'Add or remove tag to quote', 'automatorwp-pro' ),
            'select_option'     => __( 'Add or remove <strong>tag</strong> to quote', 'automatorwp-pro' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. %3$s: Quote ID. */
            'edit_label'        => sprintf( __( '%1$s tag %2$s to %3$s', 'automatorwp-pro' ), '{operation}', '{tag}', '{quote}' ),
            /* translators: %1$s: Operation (add or remove). %2$s: Tag. %3$s: Quote ID. */
            'log_label'         => sprintf( __( '%1$s tag %2$s to %3$s', 'automatorwp-pro' ), '{operation}', '{tag}', '{quote}' ),
            'options'           => array(
                'operation' => array(
                    'from' => 'operation',
                    'fields' => array(
                        'operation' => array(
                            'name' => __( 'Operation:', 'automatorwp-pro' ),
                            'type' => 'select',
                            'options' => array(
                                'add'       => __( 'Add', 'automatorwp-pro' ),
                                'remove'    => __( 'Remove', 'automatorwp-pro' ),
                            ),
                            'default' => 'add'
                        ),
                    )
                ),
                'tag' => automatorwp_utilities_ajax_selector_option( array(
                    'field'             => 'tag',
                    'option_default'    => __( 'Select a tag', 'automatorwp-pro' ),
                    'name'              => __( 'Tag:', 'automatorwp-pro' ),
                    'action_cb'         => 'automatorwp_jetpack_crm_get_quote_tags',
                    'options_cb'        => 'automatorwp_jetpack_crm_options_cb_tag',
                    'default'           => ''
                ) ),
                'quote' => array(
                    'from' => 'quote',
                    'default' => __( 'quote', 'automatorwp-pro' ),
                    'fields' => array(
                        'quote' => array(
                            'name' => __( 'Quote ID:', 'automatorwp-pro' ),
                            'type' => 'text',
                        ),
                    )
                ),
            ),
        ) );

    }

    /**
     * Action execution function
     *
     * @since 1.0.0
     *
     * @param stdClass  $action             The action object
     * @param int       $user_id            The user ID
     * @param array     $action_options     The action's stored options (with tags already passed)
     * @param stdClass  $automation         The action's automation object
     */
    public function execute( $action, $user_id, $action_options, $automation ) {

        global $wpdb;

        // Shorthand
        $operation = $action_options['operation'];
        $tag_id = $action_options['tag'];
        $quote = $action_options['quote'];

        // Ensure operation default value
        if( empty( $operation ) ) {
            $operation = 'add';
        }

        // Bail if empty tag to assign
        if( empty( $tag_id ) ) {
            return;
        }

       // Bail if empty quote
       if( empty( $quote ) ) {
        return;
        }

        $obj_quote = new zbsDAL_quotes;

        switch ( $operation ) {
            case 'add':
                 // Add tag to the quote
                 $quote_data = array(
                    'id'    => $quote,
                    'tag_input'  => array( $tag_id ),
                );
        
                $tag_id = $obj_quote->addUpdateQuoteTags( $quote_data );
                
                break;
            case 'remove':
                // Remove tag from the quote
                $quote_data = array(
                    'id'    => $quote,
                    'tag_input'  => array( $tag_id ),
                    'mode' => 'remove'
                );
        
                $tag_id = $obj_quote->addUpdateQuoteTags( $quote_data );
                break;
        }


    }

}

new AutomatorWP_Jetpack_CRM_Quote_Tag();